package gov.va.med.mhv.sm.web.util;

import gov.va.med.mhv.sm.enumeration.SystemFolderEnum;
import gov.va.med.mhv.sm.model.Folder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class FolderVO {
	private String name;
	private Long id;
	private boolean systemFolder;
	
	
	
	public FolderVO() {
		Locale.setDefault(Locale.ENGLISH);
	}
	
	public FolderVO(Long id, String name, boolean systemFolder) {
		this.id=id;
		this.name=name;
		this.systemFolder=systemFolder;
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public boolean isSystemFolder() {
		return systemFolder;
	}

	public void setSystemFolder(boolean systemFolder) {
		this.systemFolder = systemFolder;
	}
	
	public static final Comparator<FolderVO> SYSTEM_FOLDER_SORTER = new Comparator<FolderVO>() {
		public int compare(FolderVO a, FolderVO b) {
			SystemFolderEnum af = SystemFolderEnum.valueOf(a.getId());
			SystemFolderEnum bf = SystemFolderEnum.valueOf(b.getId());;
			if(af == null || bf == null) return 0;
			return af.getSortOrder().compareTo(bf.getSortOrder());
		}
	};

	public static final Comparator<FolderVO> USER_FOLDER_SORTER = new Comparator<FolderVO>() {
		public int compare(FolderVO a, FolderVO b) {
			if(a == null || b == null) return 0;
			return a.getName().toUpperCase().compareTo(b.getName().toUpperCase());
		}
	};
	
	public static List<FolderVO> getSortedList( List<FolderVO> oldList) {
		List<FolderVO> newList = new ArrayList<FolderVO>();
		
		List<FolderVO> lsf = new ArrayList<FolderVO>();
		List<FolderVO> luf = new ArrayList<FolderVO>();
		for(FolderVO folder: oldList) {
			if( folder.isSystemFolder() ) {
				lsf.add(folder);
			}
			else {
				luf.add(folder);
			}
		}
		
		Collections.sort(lsf, SYSTEM_FOLDER_SORTER);
		Collections.sort(luf, USER_FOLDER_SORTER);
		
		newList.addAll(lsf);
		newList.addAll(luf);
		
		return newList;
	}
	
	public static List<FolderVO> createFolderVOList( Collection<Folder> c ) {
		List<FolderVO> list = new ArrayList<FolderVO>();
		
		for(Folder f: c) {
			list.add(new FolderVO(f.getId(),f.getName(),f.isSystemFolder()));
		}
		
		return getSortedList(list);
	}
	
}
